<?php
declare(strict_types=1);

require __DIR__ . '/../lib/auth.php';
auth_boot();
require_login();
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
  <title>Cafona Libraire Intelligent</title>
</head>
<body class="wrap">
  <header class="topbar">
    <div>
      <h1>Cafona Libraire Intelligent</h1>
      <div class="muted">Ventes • Petite caisse • Stock • Résumé</div>
    </div>
    <nav class="nav">
      <a href="admin.php">Admin</a>
      <a href="logout.php">Quitter</a>
    </nav>
  </header>

  <main class="chat">
    <div id="messages" class="messages"></div>

    <div class="hint card">
      <b>Exemples :</b>
      <div class="chips">
        <button class="chip" data-msg="Vendu 3 cahiers 200 pages à 500 FCFA">Vente</button>
        <button class="chip" data-msg="Dépense 2000 transport">Dépense</button>
        <button class="chip" data-msg="Ajoute 20 cahiers 200 pages">Stock +</button>
        <button class="chip" data-msg="Montre les articles en rupture">Rupture</button>
        <button class="chip" data-msg="Fais le résumé du jour">Résumé</button>
      </div>
    </div>

    <form id="chatForm" class="composer">
      <input id="text" autocomplete="off" placeholder="Écris ici… (ex: Vendu 2 livres maths CM2 à 2500)">
      <button type="submit">Envoyer</button>
    </form>
  </main>

  <script src="assets/app.js"></script>
</body>
</html>
