<?php
declare(strict_types=1);

require __DIR__ . '/../lib/db.php';
require __DIR__ . '/../lib/auth.php';
auth_boot();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['username'] ?? '');
  $p = $_POST['password'] ?? '';

  $stmt = db()->prepare("SELECT id, username, pass_hash, role FROM users WHERE username = ?");
  $stmt->execute([$u]);
  $user = $stmt->fetch();

  if ($user && password_verify($p, $user['pass_hash'])) {
    $_SESSION['uid'] = (int)$user['id'];
    $_SESSION['role'] = $user['role'];
    header('Location: index.php');
    exit;
  }
  $error = 'Identifiants invalides.';
}
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
  <title>Cafona Libraire – Connexion</title>
</head>
<body class="wrap">
  <div class="card">
    <h1>Connexion</h1>
    <p class="muted">Compte initial: <b>owner</b> / <b>ChangeMe123!</b></p>
    <?php if ($error): ?><div class="alert"><?= htmlspecialchars($error) ?></div><?php endif; ?>
    <form method="post">
      <label>Utilisateur</label>
      <input name="username" required>
      <label>Mot de passe</label>
      <input type="password" name="password" required>
      <button type="submit">Se connecter</button>
    </form>
  </div>
</body>
</html>
