# Cafona Libraire Intelligent (Web MVP - PHP + MySQL)

## What this is
A chat-driven assistant for a bookstore to record:
- Sales (ventes)
- Petty cash expenses (petite caisse)
- Stock in (ajout stock)
- Stock alerts + end-of-day summary

Runs on shared hosting (cPanel) using PHP + MySQL.

---

## 1) Install (cPanel)

### A. Create database
1. cPanel → **MySQL Databases**
2. Create a DB and a DB user, grant **ALL PRIVILEGES**
3. Note DB name/user/pass

### B. Import schema
1. cPanel → **phpMyAdmin**
2. Select your DB
3. Import `schema.sql`

### C. Upload files
Upload the folder `cafona_libraire_intelligent/` into:
- `public_html/libraire/`  (recommended)

### D. Configure
Edit `config/config.php`:
- Set DB credentials
- Optionally set AI API key/model
- If you want $0 AI spend: set `'mode' => 'rules'`

### E. Open the app
Go to:
- `/libraire/cafona_libraire_intelligent/public/login.php`  (if you uploaded inside /libraire/)
or
- `/libraire/public/login.php` (if you uploaded contents directly)

Default login:
- username: `owner`
- password: `ChangeMe123!`  (change after install)

---

## 2) Cron (Daily Summary at 20:00)
cPanel → Cron Jobs

Example command:
/usr/local/bin/php -q /home/YOURCPANELUSER/public_html/libraire/cafona_libraire_intelligent/cron/daily_summary.php

Schedule:
- Minute: 0
- Hour: 20

---

## 3) Usage examples (French)
- Vente: "Vendu 3 cahiers 200 pages à 500 FCFA"
- Dépense: "Dépense 2000 transport"
- Stock: "Ajoute 20 cahiers 200 pages"
- Rupture: "Montre les articles en rupture"
- Résumé: "Fais le résumé du jour"

---

## 4) Method of Procedure (MOP) for NULLs / missing data

### Goal
Prevent empty values (NULL/0) from breaking reporting or causing wrong stock/cash.

### A. Product name missing
- System: blocks the operation.
- Procedure: repeat with a product name OR add product in Admin.

### B. Unit price missing in a sale
- System:
  1) Uses `products.sell_price` if message has no price
  2) If sell_price is 0, sale total becomes 0 (still recorded)
- Procedure:
  - Set sell_price in Admin for frequent items
  - If assistant replies with 0 FCFA, update product price and redo the sale entry

### C. Product not found
- System: auto-creates product with sell_price=0, stock=0
- Procedure: go to Admin and set correct price/category/reorder_level

### D. Quantity missing/invalid
- System:
  - sales qty <=0 normalized to 1
  - stock_in qty <=0 rejected
- Procedure: repeat with correct qty

### E. Expense amount missing/0
- System: rejected
- Procedure: repeat with amount (e.g., "Dépense 1500 livraison")

### F. Stock negative
- System: can go negative if you sell before stocking
- Procedure: add stock later ("Ajoute 10 ...")
- (Optional in v2: forbid negative stock)

### G. Payment method missing
- System: defaults to cash
- Procedure: (v2) add auto-detect "mobile money", "carte" etc.

### H. Reporting with NULLs
- SQL uses COALESCE(SUM(...),0), so totals never return NULL.

---

## 5) Security / cost controls
- Login required (session)
- Rate limit per hour (config)
- Daily AI calls cap (config)
- $0 AI: mode='rules'
