<?php
declare(strict_types=1);

require __DIR__ . '/../lib/db.php';
require __DIR__ . '/../lib/auth.php';
require __DIR__ . '/../lib/utils.php';

auth_boot();
require_login();

$in = json_input();
$name = normalize_name((string)($in['name'] ?? ''));
if ($name === '') json_out(['ok'=>false,'error'=>'Nom requis.'], 400);

$category = trim((string)($in['category'] ?? 'Livre')) ?: 'Livre';
$sell = (float)($in['sell_price'] ?? 0);
$stock = (int)($in['stock_qty'] ?? 0);
$reorder = (int)($in['reorder_level'] ?? 0);

$stmt = db()->prepare("
  INSERT INTO products (name, category, sell_price, stock_qty, reorder_level)
  VALUES (?, ?, ?, ?, ?)
  ON DUPLICATE KEY UPDATE category=VALUES(category), sell_price=VALUES(sell_price),
    stock_qty=VALUES(stock_qty), reorder_level=VALUES(reorder_level), active=1
");
$stmt->execute([$name, $category, $sell, $stock, $reorder]);

json_out(['ok'=>true]);
