<?php
declare(strict_types=1);

require __DIR__ . '/../lib/db.php';

$date = date('Y-m-d');

$sales = db()->prepare("SELECT COALESCE(SUM(amount),0) AS s FROM transactions WHERE type='sale' AND DATE(created_at)=?");
$sales->execute([$date]);
$totalSales = (float)($sales->fetch()['s'] ?? 0);

$exp = db()->prepare("SELECT COALESCE(SUM(amount),0) AS e FROM transactions WHERE type='expense' AND DATE(created_at)=?");
$exp->execute([$date]);
$totalExp = (float)($exp->fetch()['e'] ?? 0);

$net = $totalSales - $totalExp;

$top = db()->prepare("
  SELECT p.name, SUM(t.quantity) AS qty, SUM(t.amount) AS amt
  FROM transactions t
  JOIN products p ON p.id=t.product_id
  WHERE t.type='sale' AND DATE(t.created_at)=?
  GROUP BY p.id
  ORDER BY amt DESC
  LIMIT 5
");
$top->execute([$date]);
$topRows = $top->fetchAll();

$topJson = json_encode($topRows, JSON_UNESCAPED_UNICODE);

$stmt = db()->prepare("
  INSERT INTO daily_summary (summary_date, total_sales, total_expenses, net_cash, top_items)
  VALUES (?, ?, ?, ?, ?)
  ON DUPLICATE KEY UPDATE total_sales=VALUES(total_sales), total_expenses=VALUES(total_expenses),
    net_cash=VALUES(net_cash), top_items=VALUES(top_items), generated_at=CURRENT_TIMESTAMP
");
$stmt->execute([$date, $totalSales, $totalExp, $net, $topJson]);

echo "OK {$date}\n";
