<?php
declare(strict_types=1);

function rate_limit_or_die(string $key, int $maxPerHour): void {
  $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
  $bucket = date('YmdH');
  $storeKey = "rl_{$key}_{$ip}_{$bucket}";

  if (!isset($_SESSION[$storeKey])) $_SESSION[$storeKey] = 0;
  $_SESSION[$storeKey]++;

  if ($_SESSION[$storeKey] > $maxPerHour) {
    http_response_code(429);
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'Rate limit exceeded. Try later.']);
    exit;
  }
}
