// Cafona Libraire Intelligent – client UI
// Keep it dependency-free for cPanel.

(function themeInit(){
  const key = 'cafona_theme';
  const saved = localStorage.getItem(key);
  const prefersLight = window.matchMedia && window.matchMedia('(prefers-color-scheme: light)').matches;
  const theme = saved || (prefersLight ? 'light' : 'dark');
  document.documentElement.dataset.theme = theme;

  window.__toggleTheme = function(){
    const next = (document.documentElement.dataset.theme === 'light') ? 'dark' : 'light';
    document.documentElement.dataset.theme = next;
    localStorage.setItem(key, next);
  };
})();

const messages = document.getElementById('messages');
const form = document.getElementById('chatForm');
const input = document.getElementById('text');

function escapeHtml(str){
  return String(str)
    .replaceAll('&','&amp;')
    .replaceAll('<','&lt;')
    .replaceAll('>','&gt;')
    .replaceAll('"','&quot;')
    .replaceAll("'",'&#039;');
}

function addMsg(text, who) {
  const div = document.createElement('div');
  div.className = `msg ${who}`;

  // Lightweight formatting: keep new lines, and turn simple lists into bullets.
  const safe = escapeHtml(text);
  const lines = safe.split('\n');
  const looksLikeList = lines.some(l => /^\s*[-*•]\s+/.test(l));
  if (looksLikeList){
    div.innerHTML = lines.map(l=>{
      const m = l.match(/^\s*([-*•])\s+(.*)$/);
      return m ? `• ${m[2]}` : l;
    }).join('<br>');
  } else {
    div.innerHTML = safe.replaceAll('\n','<br>');
  }

  messages.appendChild(div);
  div.scrollIntoView({behavior:'smooth', block:'end'});
}

document.querySelectorAll('[data-action="theme"]').forEach(b=>{
  b.addEventListener('click', () => window.__toggleTheme && window.__toggleTheme());
});

document.querySelectorAll('.chip').forEach(b => {
  b.addEventListener('click', () => {
    input.value = b.dataset.msg || '';
    input.focus();
  });
});

form.addEventListener('submit', async (e) => {
  e.preventDefault();
  const text = (input.value || '').trim();
  if (!text) return;

  addMsg(text, 'me');
  input.value = '';
  input.focus();

  try {
    const res = await fetch('../api/chat.php', {
      method: 'POST',
      headers: {'Content-Type':'application/json'},
      body: JSON.stringify({message: text})
    });
    const data = await res.json();
    if (data.ok) addMsg(data.reply, 'bot');
    else addMsg('Erreur: ' + (data.error || 'Réponse invalide'), 'bot');
  } catch (err) {
    addMsg('Erreur réseau.', 'bot');
  }
});

// Convenience: Ctrl/Cmd + K focuses the input
document.addEventListener('keydown', (e)=>{
  if ((e.ctrlKey || e.metaKey) && e.key.toLowerCase() === 'k'){
    e.preventDefault();
    input && input.focus();
  }
});
