<?php
declare(strict_types=1);

require __DIR__ . '/../lib/auth.php';
auth_boot();
require_login();
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
  <title>Cafona Libraire Intelligent</title>
</head>
<body>
  <div class="container app">
    <aside class="sidebar">
      <div class="brand">
        <img src="assets/img/logo.svg" alt="Cafona">
        <div>
          <div class="title">Cafona Libraire</div>
          <div class="muted small">Assistant ventes • caisse • stock</div>
        </div>
      </div>

      <div class="badge" style="margin-top:10px;">
        <span style="display:inline-flex;width:10px;height:10px;border-radius:999px;background:var(--success)"></span>
        <span>Connecté</span>
      </div>

      <nav class="nav" aria-label="Navigation">
        <a class="active" href="index.php"><span>Assistant</span><span class="muted">↩</span></a>
        <a href="admin.php"><span>Administration</span><span class="muted">↗</span></a>
        <a href="logout.php"><span>Déconnexion</span><span class="muted">⎋</span></a>
      </nav>

      <div class="card" style="margin-top:14px;">
        <h3>Raccourcis</h3>
        <div class="muted">Clique pour pré-remplir</div>
        <div class="chips">
          <button class="chip" type="button" data-msg="Vendu 3 cahiers 200 pages à 500 FCFA">Vente</button>
          <button class="chip" type="button" data-msg="Dépense 2000 transport">Dépense</button>
          <button class="chip" type="button" data-msg="Ajoute 20 cahiers 200 pages">Stock +</button>
          <button class="chip" type="button" data-msg="Montre les articles en rupture">Rupture</button>
          <button class="chip" type="button" data-msg="Fais le résumé du jour">Résumé</button>
        </div>
        <div class="footer-note">Astuce: <b>Ctrl/Cmd + K</b> pour revenir au champ de saisie.</div>
      </div>
    </aside>

    <main>
      <header class="topbar">
        <div>
          <h1>Assistant intelligent</h1>
          <div class="muted">Saisis une action en français. L’IA comprend la vente, la caisse, le stock et les résumés.</div>
        </div>
        <div class="top-actions">
          <button class="btn ghost" type="button" data-action="theme" title="Changer le thème">Thème</button>
          <a class="btn" href="admin.php">Admin</a>
        </div>
      </header>

      <section class="kpis">
        <div class="kpi">
          <div class="label">Objectif</div>
          <div class="value">Zéro friction</div>
          <div class="muted small">Des phrases simples → des écritures automatiques.</div>
        </div>
        <div class="kpi">
          <div class="label">Contrôle</div>
          <div class="value">Stock à jour</div>
          <div class="muted small">Alertes de rupture via “Rupture”.</div>
        </div>
        <div class="kpi">
          <div class="label">Pilotage</div>
          <div class="value">Résumé</div>
          <div class="muted small">Rapport journalier en un message.</div>
        </div>
      </section>

      <section class="card chat" aria-label="Conversation">
        <div id="messages" class="messages" role="log" aria-live="polite"></div>

        <form id="chatForm" class="composer" autocomplete="off">
          <input id="text" autocomplete="off" placeholder="Ex: Vendu 2 livres maths CM2 à 2500 FCFA">
          <button class="btn primary" type="submit">Envoyer</button>
        </form>

        <div class="muted small" style="margin-top:8px;">
          Exemples : “Ajoute 10 stylos”, “Dépense 1500 livraison”, “Montre les ventes du jour”.
        </div>
      </section>
    </main>
  </div>

  <script src="assets/app.js"></script>
</body>
</html>
